﻿const SECUENCIA = ['VERDE','AZUL'];

const COLORES = new Map([
	['VERDE','#10253f'],
	['AZUL','#2596be']
]);

function conectar_vc() {
	var juser = get('user');
	var jpass = get('pass');
	url = get("url") + "phpfiles/login.php?user=" + juser + "&pass=" + jpass;
	var resultado = JSON.parse(ajax(url));
	if (resultado['status'] == "ok") {
		changeElementValue('formato', 'fmt01');
		pui.click();
	}
	else {
		changeElementValue('errlog', 'Usuario/contraseña incorrecta');
	}
}

function carga_inicial() {
	document.body.style.overflow = "hidden";
	crear_tabla();
	comprobar_motores();

	applyProperty('capaalta', 'top', '300px');
	applyProperty('capaalta', 'left', '200px');

	applyProperty('capaoculta', 'top', '-10px');
	applyProperty('capaoculta', 'left', '-10px');
	applyProperty('capaoculta', 'height', '1000px');
	applyProperty('capaoculta', 'width', '1700px');

	applyProperty('htmlvideo', 'top', '130px');
	applyProperty('htmlvideo', 'left', '500px');
	applyProperty('htmlvideo', 'width', '507px');
	applyProperty('htmlvideo', 'height', '1200px');

	applyProperty('capaoculta_inputs', 'top', '130px');
	applyProperty('capaoculta_inputs', 'left', '15px');

	applyProperty('capaoculta_verde', 'top', '130px');
	applyProperty('capaoculta_verde', 'left', '15px');

	document.getElementById("capaoculta").style.opacity = "0.7";

	input_focus();
}



function generar_destino() {

	changeElementValue('txterror', '');
	applyProperty('capadestino', 'visibility', 'hidden');

	var jproceso = 'CONSULTA';
	var jras = get('ras');
	var jwarehouse = get('warehouse');

	var jbulto = get('bultow').trim();

	if (jbulto == '') {
		return;
	}

	jurl = "./phpfiles/clasificacion_visualcheck_actualiza.php?ras=" + jras +
		"&warehouse=" + jwarehouse +
		"&bulto=" + jbulto +
		"&proceso=" + jproceso;
	jrespuesta = ajaxJSON(jurl);
	if (jrespuesta['status'] != 'OK') {
		if (jrespuesta['status'] == 'NO EXISTE EL ID') {
			mostrar_capa_alta();
		} else {
			changeElementValue('txterror', jrespuesta['error']);
		}

		return;
	}

	var destino = jrespuesta['destino'];

	var ult_color = jrespuesta['ultimo_color'];
	var index = SECUENCIA.indexOf(ult_color) + 1;
	if (index == SECUENCIA.length) index = 0; //comprueba si la secuencia ha terminado
	var color = COLORES.get(SECUENCIA[index]); //devuelve el valor hexadecimal del color que toca en la secuencia

	alert(ult_color);

	alert(color);

	applyProperty('capadestino', 'visibility', '');
	changeElementValue('destino', destino);
	applyProperty('bgcolor', 'background color', color);
	crear_tabla();
	applyProperty('bultow', 'disabled', 'true');
	changeElementValue('bultow', '');
	setTimeout(function () { comprobar_estado_peticion(jbulto); }, 1000);
	setTimeout(function () { desbloquear_lectura(); }, 2500);
}

function mostrar_capa_alta() {

	changeElementValue('idw', get('bultow'));
	changeElementValue('altaerror', '');

	applyProperty('capaalta', 'visibility', '');

	document.getElementById('transportistaw').focus();
}

function cancelar_capa_alta() {
	applyProperty('capaalta', 'visibility', 'hidden');
	input_focus();
}

function asignar_destino() {

	changeElementValue('altaerror', '');

	var jproceso = 'ALTA';
	var jras = get('ras');
	var jwarehouse = get('warehouse');

	var jbulto = get('idw').trim();
	var jtransportista = get('transportistaw').trim();

	if (jtransportista == '') {
		changeElementValue('altaerror', 'Debes seleccionar un transportista');
		return;
	}

	jurl = "./phpfiles/clasificacion_visualcheck_actualiza.php?ras=" + jras +
		"&warehouse=" + jwarehouse +
		"&bulto=" + jbulto +
		"&transportista=" + jtransportista +
		"&proceso=" + jproceso;
	jrespuesta = JSON.parse(ajax(jurl));
	if (jrespuesta['status'] != 'OK') {
		changeElementValue('altaerror', jrespuesta['error']);
	} else {
		changeElementValue('bultow', jbulto);
		setTimeout(function () { generar_destino(); }, 100);
		applyProperty('capaalta', 'visibility', 'hidden');
	}
}

function crear_tabla() {
	var url = "./phpfiles/clasificacion_visualcheck_precarga.php?ras=" + get('ras') + "&warehouse=" + get('warehouse');
	var respuesta = ajaxJSON(url);

	if (respuesta['status'] == "ok") {

		if (respuesta['bultos'].length != 0) {

			var tabla = '<table class="table table-bordered"><thead class="fondoNegroCabeceraTabla centradoCabecera"><tr><th>#</th><th>Bulto</th><th>Posicion</th><th>Hora</th><th>Estado</th></tr></thead><tbody id="bodyTable">';
			for (var i = 0; i < respuesta['bultos'].length; i++) {
				errores = respuesta['errores'][i];

				if (i % 2 == 0) {
					tabla += "<tr class='table-secondary centradoCabecera tablaPar'><td>";
				} else {
					tabla += "<tr class='table-secondary centradoCabecera tablaImpar'><td>";
				}
				if (errores != null) {
					tabla += "<img style='cursor:pointer' width='30px' src='images/lupat.png' onclick='ver_video(" + respuesta['bultos'][i] + ",\"LARGO\"," + errores + ");'>";
				}
				tabla += "</td><td>" + respuesta['bultos'][i] + "</td><td>" + respuesta['zonas'][i] + "</td><td>" + respuesta['horas'][i] + "</td>";

				if (errores == null) {
					tabla += "<td><div class='status statusWarning'>Procesando...</div></td></tr>"
				} else if (errores == '0') {
					tabla += "<td><div class='status statusOk'>OK</div></td></tr>"
				} else {
					tabla += "<td><div class='status statusError'>ERROR</div></td></tr>"
				}

			}
			tabla += "</tbody><table>";
			applyProperty('listapeticiones', 'html', tabla);
		}
	}
}

function desbloquear_lectura() {
	applyProperty('bultow', 'disabled', '');
	input_focus();
}

function comprobar_estado_peticion(bulto) {
	var url = "./phpfiles/clasificacion_visualcheck_comprobar_estado.php?ras=" + get('ras') + "&warehouse=" + get('warehouse') + "&bulto=" + bulto;
	var respuesta = ajaxJSON(url);
	if (respuesta['status'] == "ok") {
		var errores = respuesta['errores'];
		if (errores != null) {
			crear_tabla()
			if (errores != '0') {
				ver_video(bulto, 'CORTO', errores);
			} else {
				mostrar_capa_verde();
			}
		} else {
			setTimeout(function () { comprobar_estado_peticion(bulto); }, 1000);
		}
	} else {
		setTimeout(function () { comprobar_estado_peticion(bulto); }, 1000);
	}
}

function comprobar_motores() {
	var url = "./phpfiles/clasificacion_visualcheck_comprobar_motores.php";
	var respuesta = ajaxJSON(url);
	if (respuesta['status'] == "ok") {
		var color_vc = respuesta['color_vc'];
		if (color_vc != '') {
			applyProperty('motor_vc', 'inline style', 'background-color: ' + color_vc);
		} else {
			applyProperty('motor_vc', 'inline style', 'background-color: #f57676');
		}
		var color_api = respuesta['color_api'];
		if (color_api != '') {
			applyProperty('motor_api', 'inline style', 'background-color: ' + color_api);
		} else {
			applyProperty('motor_api', 'inline style', 'background-color: #f57676');
		}
	} else {
		applyProperty('motor_vc', 'inline style', 'background-color: #f57676');
		applyProperty('motor_api', 'inline style', 'background-color: #f57676');
	}
	setTimeout(function () { comprobar_motores(); }, 90000);
}

function ver_video(bulto, duracion, errores) {
	ruta = get('rutavideo');
	if (duracion == 'CORTO') {
		ruta += 'C';
		changeElementValue('qrw', '');
		applyProperty('qrw', 'visibility', '');
		applyProperty('lbl_qr', 'visibility', '');
		applyProperty('btverificado', 'visibility', '');
		applyProperty('ibtverificado', 'visibility', '');
		applyProperty('btvolver', 'visibility', 'hidden');
		applyProperty('ibtvolver', 'visibility', 'hidden');
	} else {
		ruta += 'T';
		applyProperty('qrw', 'visibility', 'hidden');
		applyProperty('lbl_qr', 'visibility', 'hidden');
		applyProperty('btverificado', 'visibility', 'hidden');
		applyProperty('ibtverificado', 'visibility', 'hidden');
		applyProperty('btvolver', 'visibility', '');
		applyProperty('ibtvolver', 'visibility', '');
	}
	bgcolor = '#FFFFFF';
	if (errores > 0) {
		bgcolor = '#f57676';
	}
	applyProperty('capaoculta_inputs', 'inline style', 'background-color: ' + bgcolor + ';border-radius: 8px;box-shadow: 0 2px 4px rgba(0,0,0,0.1);');

	var url = "./phpfiles/clasificacion_visualcheck_info_video.php?bulto=" + bulto + "&warehouse=" + get('warehouse');
	var respuesta = ajaxJSON(url);

	transportista = '';
	posicion = '';
	ola = '';
	if (respuesta['status'] == "ok") {
		transportista = respuesta['transportista'];
		posicion = respuesta['posicion'];
		ola = respuesta['ola'];
	}

	changeElementValue('bultovid', bulto)
	changeElementValue('transportista', transportista)
	changeElementValue('posicion', posicion)
	changeElementValue('ola', ola)

	ruta += bulto + '.mp4';
	html = "<video style='border-radius: 10px' muted autoplay controls> <source src='" + ruta + "' type='video/mp4' > </video>";
	applyProperty('htmlvideo', 'html', html);
	applyProperty('htmlvideo', 'visibility', '');
	applyProperty('capaoculta', 'visibility', '');
	applyProperty('capaoculta_inputs', 'visibility', '');
	setTimeout(function () { document.getElementById('qrw').focus(); }, 1000);

}

function cerrar_capa_video() {
	applyProperty('htmlvideo', 'visibility', 'hidden');
	applyProperty('capaoculta', 'visibility', 'hidden');
	applyProperty('capaoculta_inputs', 'visibility', 'hidden');
	applyProperty('htmlvideo', 'html', '');

	input_focus();
}

function mostrar_capa_verde() {
	applyProperty('capaoculta_verde', 'visibility', '');
	applyProperty('capaoculta', 'visibility', '');
	setTimeout(function () { cerrar_capa_verde(); }, 3000);
}

function cerrar_capa_verde() {
	applyProperty('capaoculta_verde', 'visibility', 'hidden');
	applyProperty('capaoculta', 'visibility', 'hidden');
	input_focus();
}



function mostrar_teclado() {
	applyProperty("txterr", "value", "");
	applyProperty("teclado", "left", "15px");
	applyProperty("teclado", "top", "215px");
	applyProperty("teclado", "visibility", "visible");
	applyProperty("valortecla", "value", "bultow");
	applyProperty("iteclado", "visibility", "hidden");
}

function ocultar_teclado() {
	jvalortecla = get('valortecla');
	applyProperty("teclado", "visibility", "hidden");
	if (jvalortecla == 'bultow') {
		applyProperty("iteclado", "visibility", "");
	}
	changeElementValue("valortecla", "");

	input_focus();
}

function pulsa_tecla(jtecla) {

	jvalortecla = get("valortecla");

	switch (trim(jtecla)) {
		case 'ACEPTAR':
			if (trim(jvalortecla) == "bultow") {
				ocultar_teclado();
				generar_destino();
			}
			break;
		case 'BORRAR':
			var str = document.getElementById(jvalortecla).value;
			position = document.getElementById(jvalortecla).selectionStart - 1;
			str = str.substr(0, position) + '' + str.substr(position + 1);
			changeElementValue(jvalortecla, str);
			setCaretPosition(jvalortecla, position);
			document.getElementById(jvalortecla).focus();
			break;
		case 'CANCELAR':
			if (trim(jvalortecla) == "bultow") {
				ocultar_teclado();
				document.getElementById(jvalortecla).focus();
			}
			break;
		default:
			changeElementValue(jvalortecla, get(jvalortecla) + jtecla);
			break;
	}
}


function keyHandler(e) {
	e = e || window.event;                    //Sets a global variable to the passed event object or to window.event
	if (e.keyCode == 13 || e.keyCode == 9) {
		generar_destino();
	}
	else {
		applyProperty("txterror", "value", "");
	}
}

function keyHandlerQr(e) {
	e = e || window.event;                    //Sets a global variable to the passed event object or to window.event
	if (e.keyCode == 13 || e.keyCode == 9) {
		cerrar_capa_video();
	}
	else {
		applyProperty("txterror", "value", "");
	}
}

function setCaretPosition(elemId, caretPos) {
    var el = document.getElementById(elemId);

    el.value = el.value;
    // ^ this is used to not only get "focus", but
    // to make sure we don't have it everything -selected-
    // (it causes an issue in chrome, and having it doesn't hurt any other browser)

    if (el !== null) {

        if (el.createTextRange) {
            var range = el.createTextRange();
            range.move('character', caretPos);
            range.select();
            return true;
        }

        else {
            // (el.selectionStart === 0 added for Firefox bug)
            if (el.selectionStart || el.selectionStart === 0) {
                el.focus();
                el.setSelectionRange(caretPos, caretPos);
                return true;
            }

            else  { // fail city, fortunately this never happens (as far as I've tested) :)
                el.focus();
                return false;
            }
        }
    }
}

function input_focus() {
	document.getElementById('bultow').focus();
}

