<?php
session_start(); 
////
/// Cierre Jornada
///

//$file = fopen("log.txt", "w");   /// BORRAR LOG
//fwrite($file, "Error $error". PHP_EOL);
//fclose($file);


header("Content-Type: clasificacion_visualcheck/json");

//------------------------------------------------ Prepara la primera pantalla -----------------------------------------------------------------------------------------
$view='jsonfiles/clasificacion_visualcheck.json';

$data1=array();
$grid=array();
$output = array();

$config = require ('config.php');
$conexion=$config['conexion']; 
$conn = pg_connect($conexion);
$data1['logo'] = 'images/logo.png';
$data1['url']= $config['URL'];
$data1['rutavideo']= $config['rutavideo'];
$data1['extjs']='jscss/clasificacion_visualcheck.js?'.trim(date_timestamp_get(date_create()));
$data1['extcss']='jscss/visual_check.css';

$ras = $_GET['ras'];
$warehouse = $_GET['warehouse'];

$data1['ras'] = $ras;
$data1['warehouse'] = $warehouse;


if (isset($_POST["exit"]) && $_POST["exit"] == '1') { 

	return;

} else {

	carga_destinos($conn, $ras, $warehouse);
	carga_transportistas($conn, $warehouse);
	carga_motores($conn);
}

pg_close($conn);

if(isset($_POST['dest'])){
	$destino = $_POST['dest'];
	$data1['destino'] = $destino;
	$data1['vcapadestino'] = 1;
} else {
	$data1['vcapadestino'] = 0;
}
if(isset($_POST['color'])){
	$bgcolor = $_POST['color'];
	$data1['bgcolor'] = $bgcolor;
}


$formato = 'fmt01';
if(isset($_POST['formato'])){
	$formato = $_POST['formato'];
}
$data1['formato'] = $formato;
$output = array('data' => $data1, 'view' => $view, 'screen' => $formato);


echo json_encode($output);	

// ------------------------------------------------------------------

function login(){
	
}


function carga_destinos($conn, $ras, $warehouse){
	global $data1;
	$grid = array();

	$sql = "select pic,zona,to_char(momento_inicio,'HH24:MI') as momento_inicio from peticiones where ras = $1 and pic in (select inventory_id from dhl_link_id where warehouse_id = $2) order by momento_inicio desc limit 10";
	$bind = array($ras, $warehouse);
	$result = pg_query_params($conn, $sql, $bind) or die('La consulta fallo: ' . pg_last_error());
	while ($row = pg_fetch_array($result, NULL, PGSQL_ASSOC)) {

		$pic = $row['pic'];
		$zona = $row['zona'];
		$momento_inicio = $row['momento_inicio'];
		array_push($grid, array('bulto' => $pic,
								'pos' => $zona,
								'hora' => $momento_inicio
								));
	}

	pg_free_result($result);
	
	$data1['griddestinos'] = $grid;

}

function carga_transportistas($conn, $warehouse) {
	global $data1;

	$transportistas = '';
	
	$sql = "select distinct carrier from dhl_link_id where warehouse_id = $1";
	$bind = array($warehouse);
	$result = pg_query_params($conn, $sql, $bind) or die('La consulta fallo: ' . pg_last_error());
	while ($row = pg_fetch_array($result, NULL, PGSQL_ASSOC)) {

		$transportista = $row['carrier'];
		
		$transportistas .= $transportistas == '' ? $transportista : ','.$transportista; 
	}

	pg_free_result($result);
	
	$data1['transportistas'] = $transportistas;
}

function carga_motores($conn) {

	global $data1;

	$motor_vc = '';
	$motor_api = '';
	
	$sql = "select proceso, descripcion from log_motores where proceso = 'VISUALCHECK' or proceso = 'API'";
	$result = pg_query($conn, $sql) or die('La consulta fallo: ' . pg_last_error());
	while ($row = pg_fetch_array($result, NULL, PGSQL_ASSOC)) {

		$proceso = $row['proceso'];
		$descripcion = $row['descripcion'];

		if ($proceso == 'VISUALCHECK') $motor_vc = $descripcion;
		if ($proceso == 'API') $motor_api = $descripcion;
	}

	pg_free_result($result);
	
	$data1['motor_vc'] = $motor_vc;
	$data1['motor_api'] = $motor_api;

}

?>