#-------------------------------------------------------------------------------
# Name:        module1
# Purpose:
#
# Author:      tresco01
#
# Created:     14/06/2021
# Copyright:   (c) tresco01 2021
# Licence:     <your licence>
#-------------------------------------------------------------------------------

import json
import aux_function
import sys
import psycopg2 as psql


cx_Oracle = aux_function.obtener_conexion()
try:
    jsonConfig = open('config.json')
    cfg = json.load(jsonConfig)
    jsonConfig.close()
except Exception as e:
    aux_function.graba_log('config', 'Error al abrir o parsear el JSON de configuracion')
    sys.exit(1)
try:
    db = cfg['db']
    #connection = cx_Oracle.connect(db['user'], db['passwd'], f"{db['ip']}/{db['schema']}")
    # connection = cx_Oracle.connect("RTPORACLE", "RTPORACLE", "10.200.4.116/m3cogor1")
    connection = psql.connect(db)
    cursor = connection.cursor()
except Exception as e:
    aux_function.graba_log('conexion', 'No se puedo conectar con Oracle # Timeout\n' + str(e))
    sys.exit()
if connection:
    print('Conectado a Oracle')
    # CALL STORED PROCEDURE IN POSTGRES

    contador = 0
    # call the stored procedure
    tipo = 'CST'
    cursor.execute("CALL GET_CONTADOR(%s,%s);", [tipo, contador])
    res = cursor.fetchone()
    contador = res[0]
    contenedores = aux_function.recupera_informacion_contenedores()
    crear = True
    for contenedor in contenedores:
        punto =  contenedor['mapDataCode'];
        numBucket = contenedor['podCode'];
        if(punto is not None and punto != -1):
            sql = f"SELECT UBI_X, UBI_Y FROM MAPA_ALMACEN WHERE CODIGO_PUNTO = '{punto}'"
            cursor.execute(sql)
            res = cursor.fetchone()
            if(res is not None):
                ubi_x_agv,ubi_y_agv = res
                sql = f"SELECT UBI_X, UBI_Y FROM STOCK WHERE CONTENEDOR = '{numBucket}'"
                cursor.execute(sql)
                res = cursor.fetchone()
                if(res is None and crear == True):
                    tipo = 'NSC'
                    cursor.execute("CALL GET_CONTADOR(%s,%s);", [tipo, contador])
                    res = cursor.fetchone()
                    contador = res[0]
                    sql = f"INSERT INTO STOCK (REFERENCIA,CORIGINAL,CDISPONIBLE,CASIGNADA,CREPARTO,CPREPARADA,CAJUSTADA,IDENTRADA,MENTRADA,FCADUCIDAD,FEFO,NUMSERIE,LOTE,ESTADO,ALMACEN,CONTENEDOR,ORIENTACION,ALTURA_ORDEN,ZONA_ALTURA,IDCUBETA,ZON_CUBETA,SSCC,UXC,UXSBC,UXP,FAMILIA,SUBFAMILIA,GRUPO_ESTIBA,INCOMPATIBLE,MCREACION,UBI_X,UBI_Y,UXBL,GRDIMENSION,NSC,UBI_ZONA,UBI_PASILLO,UBI_ALTURA,UBI_HUECO,UBI_POSICION,UBI_MECANIZADO,STK_OWNER,FORMACION_SSCC,PUESTO_INFLUENCIA,IDMESAROBOT)VALUES ('MESA_VACIA',1,1,0,0,0,0,LPAD('{contador}',10,'0'),CURRENT_TIMESTAMP,CURRENT_DATE,CURRENT_DATE,'MESA_VACIA',' ','OK',' ','{numBucket}',2,'0',0,'0',0,' ',0,0,0,'ME',' ','0',' ',CURRENT_TIMESTAMP,{ubi_x_agv},{ubi_y_agv},0,' ',{contador},' ',0,0,0,0,' ',' ',' ',' ',' ')"
                    cursor.execute(sql)
                    res = (ubi_x_agv,ubi_y_agv)
                if(res is not None):
                    ubi_x,ubi_y = res
                    if ubi_x == ubi_x_agv and ubi_y == ubi_y_agv:
                        sql = f"INSERT INTO CUADRE_STOCK VALUES({contador},{ubi_x},{ubi_y},{ubi_x_agv},{ubi_y_agv},'OK','{numBucket}',CURRENT_TIMESTAMP)"
                        print(f"<OK> El contenedor {numBucket} coincide con el sistema de 3CO")
                    else:
                        sql = f"INSERT INTO CUADRE_STOCK VALUES({contador},{ubi_x},{ubi_y},{ubi_x_agv},{ubi_y_agv},'DIS','{numBucket}',CURRENT_TIMESTAMP)"
                        print(f"<ERROR> El contenedor {numBucket} no coincide con el sistema de AMR")
                        cursor.execute(sql)
                        cuadrar_stock = True
                        if(cuadrar_stock == True):
                            sql = f"UPDATE STOCK SET UBI_X = {ubi_x_agv},UBI_Y = {ubi_y_agv},ESTADO = 'OK' WHERE contenedor = '{numBucket}'"
                            cursor.execute(sql)
                            sql = f"UPDATE MAPA_ALMACEN SET CONTENEDOR = '',ESTADO = 'LI' WHERE UBI_X = {ubi_x} AND UBI_Y = {ubi_y}"
                            cursor.execute(sql)
                            sql = f"UPDATE MAPA_ALMACEN SET CONTENEDOR = '{numBucket}',ESTADO = 'OC' WHERE UBI_X = {ubi_x_agv} AND UBI_Y = {ubi_y_agv}"
                            cursor.execute(sql)
            else:
                if(punto == '-1'):
                    print(f"Contenedor {numBucket } no está definido para punto en el mapa de AMR")
                else:
                    print(f"Contenedor {numBucket } no existe para punto en el mapa")

        else:
            print(f"El contenedor {numBucket} no está ubicado en el sistema AMR")
    connection.commit()
    connection.close()
    print('Fin de validacion. Resultado exportados CUADRE_STOCK')
    input()



