<?php 

// VERSION 2 ---> ENCOLA EN LA TABLA INT_RECEPCIONES LAS LLEGADAS PARA SU PROCESO POSTERIOR. 
 // Permite la conexion desde cualquier origen
 header("Access-Control-Allow-Origin: *");
 // Permite la ejecucion solo de POST
 // header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");  
 header("Access-Control-Allow-Methods:POST");  
 // Se toma la URL solicitada y se guarda en un array de datos
 // Por ejemplo si la URL solicitada es http://localhost/api/usuario
 // Esto nos ayuda a identificar cuando se esta solicitando la URL general o un elemento especifico
 $array = explode("/", $_SERVER['REQUEST_URI']);

 // Obtener el cuerpo de la solicitud HTTP
 // En nuestro caso, el cuerpo solo sera enviado en peticiones de tipo POST y PUT, en el cual recibimos el xml 
 $bodyRequest = file_get_contents("php://input");

$conn;

 // Analiza el metodo usado actualmente de los cuatro disponibles: GET, POST, PUT, DELETE
 switch ($_SERVER['REQUEST_METHOD']) {
  case 'GET':
   header("HTTP/1.1 400 Peticion Erronea");
   break;
  case 'POST':
   // Acciones del Metodo POST

   /* Analiza si existe la variable Id, ya que la URL solicita por POST solo puede ser de estilo
      http://localhost/version/intefase no habria por que existir un Id ya que se esta registrando un 
      nuevo elemento y el Id es autogenerado, si el Id no existe, entra en esta condicional */
	
	  $xml = new SimpleXMLElement("$bodyRequest");
	  $rampa = $xml->Chute;
	  $hostpic = $xml->HostPic;
	  $sku = $xml->Sku;
	  $skuDesc = $xml->SkuDescription;
	  $shop = $xml->Shop;
	  $posicion = $xml->ChutePosition;
	  
	  $skuEtiqueta = substr($sku,0,2);
	  $conn = obtener_conexion($rampa);
	  if($skuEtiqueta == "ST"){
		  actualizar_soporte($conn,$rampa,$sku,$shop,$posicion);
		insertar_peticion($conn,$rampa,$hostpic,$sku,$shop,$posicion,$skuDesc);
		
	  }
	  else{
			
			if($conn != null){
				insertar_peticion($conn,$rampa,$hostpic,$sku,$shop,$posicion,$skuDesc);
			}
			else{
				enviar_peticion_no_camara($hostpic,$rampa,$posicion,1);
			}  
	  }
	  // LLAMA a proceso de interfase en función de version e interfase:
	 $conn->close();
	header("HTTP/1.1 200 OK");
    break;
  case 'PUT':
	header("HTTP/1.1 400 Peticion Erronea");
   break;
  case 'DELETE':
   header("HTTP/1.1 400 Peticion Erronea");
   break;
  
  default:
   // Acciones cuando el metodo no se permite
   // En caso de que el Metodo Solicitado no sea ninguno de los cuatro disponible, envia la siguiente respuesta
   header("HTTP/1.1 400 Metodo no Encontrado");
   break;
 }


function actualizar_soporte($conn,$rampa,$sku,$shop,$posicion){
	$sql = "UPDATE peticiones SET soporte = '$sku' where zona = $posicion and tienda = '$shop' and ras = $rampa and soporte = ''";
	
	return $conn->exec($sql);
}

 function insertar_peticion($conn,$rampa,$hostpic,$sku,$shop,$posicion,$skuDesc){
	 $sql = "INSERT INTO disparador(VS2RAS,VS2POS,VS2PIC,VS2NPL,VS2PEN,VS2DES,VS2REF,fentrada) VALUES('$rampa','$posicion','$hostpic','','$shop','$skuDesc','$sku',datetime('now'))";
	 return $conn->exec($sql);
 }

 function obtener_conexion($rampa){
	$db = new SQLite3('multi_visual_check.db');
	$db->busyTimeout(10);
	return $db;
	
}
/*
FUNCION QUE DEVUELVE OK CUANDO NO HAY CAMARA
PARA PRUEBAS
*/
function enviar_peticion_no_camara($hostpic,$rampa,$posicion,$exito){
	$xml = "<?xml version='1.0' encoding='UTF-8'?><VisualCheckResponseData><HostPic>".$hostpic."</HostPic><Chute>".$rampa."</Chute><ChutePosition>".$posicion."</ChutePosition><TrackingSuccess>".$exito."</TrackingSuccess><VideoLinkUrl>http:randomUrl</VideoLinkUrl></VisualCheckResponseData>";
	
	
	$curl = curl_init();
	curl_setopt_array($curl, array(
	  CURLOPT_URL => "http://10.39.126.135:5010/api/VisualCheck/response",
	  CURLOPT_RETURNTRANSFER => true,
	  CURLOPT_ENCODING => "",
	  CURLOPT_MAXREDIRS => 10,
	  CURLOPT_TIMEOUT => 30,
	  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	  CURLOPT_CUSTOMREQUEST => "POST",
	  CURLOPT_POSTFIELDS => "xmlRequest=".$xml,
	  CURLOPT_HTTPHEADER => array(
		"Accept: */*",
		"Accept-Encoding: gzip, deflate",
		"Cache-Control: no-cache",
		"Connection: keep-alive",
		"Content-Length: 200",
		"Content-Type: application/x-www-form-urlencoded",
		"Host: localhost",
		"cache-control: no-cache"
	  ),
	));

	$response = curl_exec($curl);
	$err = curl_error($curl);

	curl_close($curl);

	if ($err) {
	  echo "cURL Error #:" . $err;
	} else {
	  echo $response;
	}
}



 
?>
